module net.BurtonRadons.dedit.highlight.bat;

import net.BurtonRadons.dedit.main;
import std.path;
import std.string;

/** MS-DOS batch file highlighter. */
class Bat_Highlighter : SyntaxHighlighter
{
    char [] [] reservedBase =
    [
        "cd",
        "copy",
        "del",
        "echo",
        "if",
        "mkdir",
        "move",
        "rem",
        "set",
    ];

    bit [char []] reserved;

    const char [] symbols = "()[]<>{}:;=!%^&*-+|/.,$";

    bit [char []] keywordDict (char [] [] base)
    {
        bit [char []] dict;

        for (int c; c < base.length; c ++)
            dict [base [c]] = true;

        return dict;
    }

    this ()
    {
        reserved = keywordDict (reservedBase);
    }

    static this ()
    {
        list ~= new Bat_Highlighter ();
    }

    override char [] name () { return "MS-DOS Batch File"; }
    override char [] exts () { return "*.bat"; }

    override float match (char [] filename, char [] [] data)
    {
        if (!icmp (getExt (filename), "bat"))
            return 1;
        return 0;
    }

    final bit isSymbol (char f)
    {
        for (int c; c < symbols.length; c ++)
            if (f == symbols [c])
                return true;

        return false;
    }

    final bit isIdentifierStart (char f) { return std.ctype.isalpha (f) || f == '_'; }
    final bit isIdentifierBody (char f) { return std.ctype.isalnum (f) || f == '_'; }

    /* We take nothing. */
    override int extraSize () { return 0; }

    override void highlight (char [] line, char [] high, void *lastp, void *nextp)
    {
        char *c, h, e;
        char [] r;
        int n;
        char code;

        code = 0;
        c = line;
        h = high;
        e = c + line.length;

        /* Handle initial spaces and "@" */
        while (c < e)
        {
            if (*c == '@')
                *h ++ = 's', c ++;
            else if (std.ctype.isspace (*c))
                *h ++ = 0, c ++;
            else
                break;
        }

        if (c >= e)
            goto finish;

        /* Handle initial command. */
        if (isIdentifierStart (*c))
        {
            int f;

            n = (int) (e - c);
            for (f = 1; f < n && isIdentifierBody (c [f]); f ++)
                {}
            r = std.string.tolower (c [0 .. f]);

            h [0 .. f] = (r in reserved) ? 'r' : 'i';
            h += f;
            c += f;
        }

        /* set XXX=VALUE */
        if (r == "set")
        {
            while (c < e)
            {
                if (std.ctype.isspace (*c))
                    *h ++ = 0, c ++;
                else
                    break;
            }

            while (c < e)
            {
                if (*c == '=')
                    break;
                else
                    *h ++ = 'm', c ++;
            }
        }
        else if (r == "echo")
        {
            while (c < e)
            {
                *h ++ = '"';
                c ++;
            }
        }
        else if (r == "rem")
        {
            while (c < e)
                *h ++ = '*', c ++;
        }

        while (c < e)
        {
            n = (int) (e - c);

            if (*c == '%')
            {
                if (code == 'm')
                    code = 0;
                else
                    code = 'm';
                *h ++ = 'm';
                c ++;
            }
            else
            {
                *h ++ = code;
                c ++;
            }
        }

    finish:
        return;
    }
}

